﻿<%@ Page Title="" Language="C#" MasterPageFile="~/MasterPageExt.master" AutoEventWireup="true" CodeFile="reports_pat.aspx.cs" Inherits="reports_pat" %>

<%@ MasterType VirtualPath="~/MasterPageExt.master" %>
<%@ Register Assembly="Ext.Net" Namespace="Ext.Net" TagPrefix="ext" %>
<%@ Register TagPrefix="ucTBICDS" TagName="TrendGraph" Src="~/ucTrendGraph.ascx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="cpHeader" runat="Server">
    <style>
        .gpPatPopHidden
        {
            display: none;
        }

        .gpUline
        {
            text-decoration: underline;
            cursor: pointer;
        }

        .tbi-tooltip-body
        {
            font-size: 14px;
        }

        .tbi-tooltip-footer
        {
            font-size: 10px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">

    <script type="text/javascript">

        function AriaCloseNoteBtn(el) {
            el.set({
                "role": 'button'
            });
        }

        function AriaSelPatBtn(el) {
            el.set({
                "role": 'button'
            });
        }

        function AriaShowTTBtn(el) {
            el.set({
                "role": 'button'
            });
        }
               
        function AriaShowNoteBtn(el) {
            el.set({
                "role": 'button'
            });
        }      



        ////hide edit options for tree rows as needed, N/A here
        //var TrendPrepareCommand = function (grid, command, record, row) {

        //    if (command.command == 'CMD_SHOW_TREND' && record.get('pw_event_module_id') < 1) {
        //        command.hidden = true;
        //        command.hideMode = 'visibility'; //you can try 'display' also                 
        //    }

        //};
        var vNoteSelRow = 0;
        var vNoteSelCol = 0;

        function UpdateNoteSel(row, col) {
            vNoteSelRow = row;
            vNoteSelCol = col;
            App.btnShowNote.enable();
        }

        $(document).ready(function () {
            Ext.onReady(function ()
            {
                Ext.defer(function() {App.tfPatSearch.focus(true, 100);}, 1);
            
            });
        });
       
        //grid panel command handlers for buttons in the grid 
        var OnTrendCommand = function (command, strStoreRow) {
            var filter = 3, /*3 = get all trend from close notes */
            highlight = '';

            /*subscale*/
            if (strStoreRow.pw_event_module_id == -1) {
                highlight = strStoreRow.module;
            }

            switch (command) {
                case "CMD_SHOW_TREND":
                    ucTrendGraphJS.show(strStoreRow.patient_id, strStoreRow.mid, strStoreRow.intake_id, filter, highlight);
                    break;
            }

        }

        //per spec filter must be done all client side.
        function fncPopFilter(ky) {
            //user pressed the enter key in the search box, so filter
            if (ky == 13) {
                //search string make it uppercase
                var strSearch = App.tfPatSearch.getValue();
                strSearch = strSearch.toUpperCase();

                //loop over each record in the store
                var i = 0;
                App.gpPopulation.getStore().each(function (record) {
                    //full name, make it upper case
                    var strName = record.data.FULL_NAME;
                    strName = strName.toUpperCase();

                    if (strSearch == '') {
                        //if search is empty show all records
                        App.gpPopulation.view.removeRowCls(i, 'gpPatPopHidden');

                    }
                    else {
                        if (strName.indexOf(strSearch) >= 0)
                        {
                            //if name contains search then show row
                            App.gpPopulation.view.removeRowCls(i, 'gpPatPopHidden');
                        }
                        else
                        {
                            //if name does not contain search then hide row
                            App.gpPopulation.view.addRowCls(i, 'gpPatPopHidden');
                        }
                    }

                    i++;
                });

                Ext.defer(function () { App.gpPopulation.focus(true, 200); }, 1);
            }
        }

        var onBeforeShow = function (toolTip, grid) {
            var view = grid.getView(),
                store = grid.getStore(),
                record = view.getRecord(view.findItemByChild(toolTip.triggerElement)),
                column = view.getHeaderByCell(toolTip.triggerElement);

            if (record.get(column.dataIndex) == "") {
                return false;
            }
        };

        var onShow = function (toolTip, grid) {
            var view = grid.getView(),
                store = grid.getStore(),
                record = view.getRecord(view.findItemByChild(toolTip.triggerElement)),
                column = view.getHeaderByCell(toolTip.triggerElement),
                data;

            data = Ext.encode(record.data);

            if (column.dataIndex == "SHORT_NAME") {
                data = record.get("MODULE");
            }
            else {
                var idx = column.dataIndex.split("_").pop(),
                    card = "";

                //Interpretation
                if (record.get("INTERPRETATION_" + idx) != "") {
                    card = "<div>Interpretation: " + record.get("INTERPRETATION_" + idx) + "</div><br />";
                }

                card += "<div class=\"tbi-tooltip-footer\">";

                //Date
                if (record.get("DATE_" + idx) != "") {
                    card += "Date: <strong>" + record.get("DATE_" + idx) + "</strong><br />";
                }

                //Name
                if (record.get("NAME_" + idx) != "") {
                    card += "Submitted By: <strong>" + record.get("NAME_" + idx) + "</strong>";
                }

                card += "</div>";

                data = card;
            }

            toolTip.update(data);
        };

        var fnShowNote = function (result) {
            App.taNote.setValue(result.Note);
            App.winNote.show();
        }

    </script>

    <%--Trend Graph User Control Control--%>
    <ucTBICDS:TrendGraph ID="ucTrendGraph" runat="server" />

    <%--Note Window--%>
    <ext:Window ID="winNote" runat="server"
        BodyPadding="6"
        Width="680"
        MinWidth="620" Title="Note"
        MinHeight="420"
        Hidden="true"
        IDMode="Static"
        Layout="VBoxLayout"
        Anchor="100%"
        Constrain="true"
        
        Modal="true"
        Collapsible="false"
        Resizable="false"
        Maximizable="false"
        Draggable="false" 
        XOnEsc="Ext.emptyFn">
        <LayoutConfig>
            <ext:VBoxLayoutConfig Align="Stretch" />
        </LayoutConfig>
        <Items>
            <ext:Panel ID="pnlNote"
                IDMode="Static"
                runat="server"
                Border="false"
                Anchor="100%"
                Flex="1"
                Layout="VBoxLayout">
                <LayoutConfig>
                    <ext:VBoxLayoutConfig Align="Stretch" />
                </LayoutConfig>
                <Items>
                    <ext:TextArea Padding="2" runat="server" ID="taNote" Anchor="100%" Flex="1" ReadOnly="true" />
                </Items>
            </ext:Panel>
        </Items>
         <Listeners>
            <Show Handler="Ext.defer(function() {App.taNote.focus(true, 100);}, 1);" />
            <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
            <Hide Handler="App.taNote.clear();App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
            <Close Handler="App.taNote.clear();App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />

        </Listeners>
        <BottomBar>
            <ext:Toolbar  runat="server">
                <Items>
                    <ext:Button ID="btnCloseNote" runat="server" Text="Close" Icon="None"
                        Handler="App.winNote.hide();" >
                        <Listeners>
                              <AfterRender Handler="AriaCloseNoteBtn(App.btnCloseNote.getEl());" ></AfterRender>
                        </Listeners>
                        </ext:Button>
                </Items>
            </ext:Toolbar>
        </BottomBar>
    </ext:Window>


    <ext:Panel ID="pnlReportsPatMain"
        IDMode="Static"
        runat="server"
        AnchorHorizontal="100%"
        AnchorVertical="100%"
        Layout="BorderLayout"
        AutoDoLayout="true"
        Border="false"
        Frame="false">
        <Items>

            <ext:Panel ID="pnlWest" 
                Title="Site Population" 
                Split="true" Header="true" 
                Collapsible="false"
                Layout="AnchorLayout" 
                Resizable="false"
                runat="server" 
                Region="West" 
                Flex="1" 
                Border="false" 
                Frame="false"
                Anchor="100%">
                <Items>

                    <ext:GridPanel
                        ID="gpPopulation"
                        runat="server"
                        Title=""
                        Layout="FitLayout"
                        AnchorHorizontal="100%"
                        AnchorVertical="100%"
                        ColumnLines="true"
                        RowLines="true"
                        AutoScroll="false"
                        Flex="1"
                        Border="false">
                        <TopBar>
                            <ext:Toolbar runat="server">
                                <Items>
                                    <ext:TextField FieldLabel="Search" LabelWidth="40" ID="tfPatSearch" runat="server" Width="250" Icon="Magnifier" Vtype="alphanumSpace">
                                        <Listeners>
                                            <SpecialKey Handler="fncPopFilter(e.getKey());" />
                                        </Listeners>
                                    </ext:TextField>
                                </Items>
                            </ext:Toolbar>
                        </TopBar>
                        <Listeners>
                            <CellClick Handler="App.direct.REPSPAT.OnPatSel( Ext.encode(this.store.getAt(rowIndex).data) );" />
                        </Listeners>
                        <SelectionModel>
                            <ext:RowSelectionModel runat="server" Mode="Single">
                                <Listeners>
                                </Listeners>
                                <CustomConfig>
                                </CustomConfig>
                            </ext:RowSelectionModel>
                        </SelectionModel>
                        <ColumnModel ID="ColumnModel1" runat="server">
                            <Columns>

                                <ext:Column ID="Column1" runat="server"
                                    DataIndex="FULL_NAME" Text="Name"
                                    Flex="43" >
                                    <Filter>
                                    <ext:ListFilter></ext:ListFilter>
                                    </Filter>
                                </ext:Column>
                                <ext:Column ID="Column2" runat="server"
                                    DataIndex="HOMEPHONE" Text="Telephone"
                                    Flex="33">
                                    <Filter>
                                    <ext:ListFilter></ext:ListFilter>
                                    </Filter>
                                    </ext:Column>
                                <ext:DateColumn ID="DateColumn1" runat="server"
                                    DataIndex="DOB" Text="DOB" Format="m/dd/Y"
                                    Width="100" >
                                    <Filter>
                                    <ext:DateFilter></ext:DateFilter>
                                    </Filter>
                                    </ext:DateColumn>

                            </Columns>
                        </ColumnModel>
                        <Store>
                            <ext:Store
                                ID="storPopulation"
                                AutoLoad="true"
                                runat="server">
                                <Model>
                                    <ext:Model ID="mdlPopulation" runat="Server" IDProperty="PATIENT_ID">
                                        <Fields>
                                            <ext:ModelField Name="PATIENT_ID" />
                                            <ext:ModelField Name="FULL_NAME" />
                                            <ext:ModelField Name="HOMEPHONE" />
                                            <ext:ModelField Name="DOB" Type="Date" />
                                        </Fields>
                                    </ext:Model>
                                </Model>
                                <Reader>
                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                    </ext:JsonReader>
                                </Reader>
                            </ext:Store>
                        </Store>
                        <Plugins>
                        <ext:GridFilters runat="server"></ext:GridFilters>
                        </Plugins>
                       
                    </ext:GridPanel>

                </Items>
                <BottomBar>
                    <ext:Toolbar runat="server">
                        <Items>
                            <ext:Button ID="btnSelPatient" runat="server" Text="Select Patient" Icon="Magnifier" Handler="App.direct.REPSPAT.OnPatSel( Ext.encode(#{gpPopulation}.getRowsValues({selectedOnly : true})));" >
                            <Listeners>
                               <AfterRender Handler="AriaSelPatBtn(App.btnSelPatient.getEl());" ></AfterRender>
                            </Listeners>
                            </ext:Button>
                        </Items>
                    </ext:Toolbar>
                </BottomBar>
            </ext:Panel>

            <ext:Panel ID="pnlCenter" Title="" Split="true" Header="true" Collapsible="false" Layout="BorderLayout"
                runat="server" Region="Center" Border="false" Frame="false" AnchorHorizontal="100%" AnchorVertical="100%" Flex="2">
                <Items>

                    <ext:Panel
                        runat="server"
                        Region="North"
                        Split="true"
                        Flex="2"
                        Border="false"
                        MaintainFlex="true"
                        Layout="VBoxLayout"
                        Frame="false">
                        <LayoutConfig>
                            <ext:VBoxLayoutConfig Align="Stretch" />
                        </LayoutConfig>
                        <Items>
                            <ext:Panel ID="pnlInstrumentTrend" 
                                Title="Patient Instrument Trend" 
                                Header="true" 
                                Layout="AnchorLayout"
                                runat="server" 
                                Border="false" 
                                Frame="false"
                                Anchor="100%"
                                Flex="1">
                                <Items>
                                        <ext:TreePanel
                                            ID="tpnlTrend"
                                            runat="server"
                                            Title=""
                                            Padding="0"
                                            Collapsible="false"
                                            UseArrows="false"
                                            RootVisible="false"
                                            MultiSelect="true"
                                            SingleExpand="false"
                                            SortableColumns="false"
                                            FolderSort="false"
                                            IDMode="Static"
                                            Layout="FitLayout"
                                            AnchorHorizontal="100%"
                                            AnchorVertical="100%"
                                            AutoScroll="true"
                                            Lines="true"
                                            ColumnLines="true"
                                            RowLines="true"
                                            Border="false">
                                            <Fields>
                                                <ext:ModelField Name="patient_id" />
                                                <ext:ModelField Name="pat_pw_id" />
                                                <ext:ModelField Name="pat_pw_event_id" />
                                                <ext:ModelField Name="pw_event_module_id" />
                                                <ext:ModelField Name="mid" />
                                                <ext:ModelField Name="module" />
                                                <ext:ModelField Name="current_score" />
                                                <ext:ModelField Name="current_interpretation" />
                                                <ext:ModelField Name="current_status" />
                                                <ext:ModelField Name="current_reviewed" Type="Boolean" />
                                                <ext:ModelField Name="prev_score" />
                                                <ext:ModelField Name="prev_interpretation" />
                                                <ext:ModelField Name="current_status" />
                                                <ext:ModelField Name="current_status_id" />
                                                <ext:ModelField Name="current_severity" />
                                                <ext:ModelField Name="current_severity_id" />
                                                <ext:ModelField Name="event_status" />
                                                <ext:ModelField Name="intake_id" />
                                            </Fields>
                                            <ColumnModel>
                                                <Columns>
                                                    <ext:TreeColumn ID="colUCOM_module"
                                                        runat="server"
                                                        Text="Instrument"
                                                        Flex="1"
                                                        Sortable="true"
                                                        DataIndex="module" />

                                                    <ext:Column ID="colUCOM_current_interpretation"
                                                        runat="server"
                                                        Text="Interpretation"
                                                        Flex="1"
                                                        Sortable="true"
                                                        DataIndex="current_interpretation" />

                                                    <ext:Column ID="colUCOM_current_score"
                                                        runat="server"
                                                        Text="Current"
                                                        Width="70"
                                                        Sortable="true"
                                                        DataIndex="current_score" />

                                                    <ext:Column ID="colUCOM_prev_score"
                                                        runat="server"
                                                        Text="Previous"
                                                        Width="70"
                                                        Sortable="true"
                                                        DataIndex="prev_score" />

                                                    <ext:Column ID="colUCOM_current_status"
                                                        runat="server"
                                                        Text="Status"
                                                        Width="70"
                                                        Sortable="true"
                                                        DataIndex="current_status" />

                                                    <ext:Column ID="Column3"
                                                        runat="server"
                                                        Text=""
                                                        Visible="false"
                                                        DataIndex="pat_pw_event_id" />

                                                    <ext:Column ID="Column4"
                                                        runat="server"
                                                        Text=""
                                                        Visible="false"
                                                        DataIndex="pat_pw_id" />

                                                    <ext:Column ID="Column5"
                                                        runat="server"
                                                        Text=""
                                                        Visible="false"
                                                        DataIndex="current_status_id" />

                                                    <ext:Column ID="Column6"
                                                        runat="server"
                                                        Text=""
                                                        Visible="false"
                                                        DataIndex="current_severity_id" />

                                                    <ext:Column ID="Column7"
                                                        runat="server"
                                                        Text=""
                                                        Visible="false"
                                                        DataIndex="current_severity" />
                                                </Columns>
                                            </ColumnModel>
                                            <Listeners>
                                            </Listeners>
                                            <SelectionModel>
                                                <ext:TreeSelectionModel ID="TreeSelectionModel1" EnableKeyNav="true" runat="server" Mode="Single">
                                                    <Listeners>
                                                         <Select Handler="App.btnMeasureTrend.enable();"></Select>
                                                    </Listeners>
                                                    <CustomConfig>
                                                    </CustomConfig>
                                                </ext:TreeSelectionModel>
                                            </SelectionModel>
                                        </ext:TreePanel>
                                </Items>
                            </ext:Panel>
                        </Items>
                    </ext:Panel>

                    <ext:Panel
                        runat="server"
                        Region="Center"
                        Split="true"
                        Flex="3"
                        MaintainFlex="true"
                        Layout="VBoxLayout"
                        Border="false"
                        Frame="false">
                        <LayoutConfig>
                            <ext:VBoxLayoutConfig Align="Stretch" />
                        </LayoutConfig>
                        <TopBar>
                            <ext:Toolbar
                                runat="server">
                                <Items>

                                    <ext:Label Text="Date range" runat="server" Padding="3"></ext:Label>
                                    <ext:DateField ID="dfFromDate"
                                        runat="server"
                                        AllowBlank="false"
                                        AutoDataBind="true"
                                        Width="100"
                                        Padding="5"
                                        Format="MM/dd/yyyy"
                                        Vtype="date"
                                        InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                    </ext:DateField>

                                    <ext:DateField ID="dfToDate"
                                        runat="server"
                                        AllowBlank="false"
                                        AutoDataBind="true"
                                        Width="100"
                                        Padding="5"
                                        Format="MM/dd/yyyy"
                                        Vtype="date"
                                        InvalidText="{0} is not a valid date - it must be in the format MM/DD/YYYY">
                                    </ext:DateField>

                                    <ext:Button ID="btnMeasureTrend" runat="server" Text="Trend" Icon="ChartBar" >
                                    <Listeners>
                                        <AfterRender Handler="AriaShowTTBtn(App.btnMeasureTrend.getEl());" ></AfterRender>
                                        <Click Handler="OnTrendCommand('CMD_SHOW_TREND', App.tpnlTrend.getSelectionModel().getSelection()[0].data);"></Click>
                                    </Listeners>
                                    </ext:Button>

                                </Items>
                            </ext:Toolbar>
                        </TopBar>
                        <Items>
                            <ext:Panel 
                                Title="Patient Total Score / Instrument" 
                                Header="true" 
                                Split="true" 
                                Collapsible="false" 
                                Layout="AnchorLayout"
                                runat="server" 
                                Region="North" 
                                Border="false" 
                                Frame="false" 
                                Flex="2" 
                                MaintainFlex="true"
                                Anchor="100%">
                                <Items>

                                    <ext:GridPanel
                                        ID="gpScores"
                                        runat="server"
                                        Title=""
                                        Layout="FitLayout"
                                        AnchorHorizontal="100%"
                                        AnchorVertical="100%"
                                        ColumnLines="true"
                                        RowLines="true"
                                        Border="false"
                                        Frame="false"
                                        AutoScroll="true">
                                        <Listeners>
                                        </Listeners>
                                        <SelectionModel>
                                            <ext:RowSelectionModel runat="server" Mode="Single">
                                                <Listeners>
                                                </Listeners>
                                                <CustomConfig>
                                                </CustomConfig>
                                            </ext:RowSelectionModel>
                                        </SelectionModel>
                                        <ColumnModel runat="server">
                                            <Columns>
                                                <ext:Column runat="server"
                                                    DataIndex="SHORT_NAME" Text="Instrument"
                                                    Flex="43">
                                                </ext:Column>
                                                <ext:Column runat="server"
                                                    DataIndex="SCORE_10" Text="10"
                                                    Flex="33" />
                                                <ext:Column runat="server"
                                                    DataIndex="SCORE_9" Text="9"
                                                    Flex="33" />
                                                <ext:Column runat="server"
                                                    DataIndex="SCORE_8" Text="8"
                                                    Flex="33" />
                                                <ext:Column runat="server"
                                                    DataIndex="SCORE_7" Text="7"
                                                    Flex="33" />
                                                <ext:Column runat="server"
                                                    DataIndex="SCORE_6" Text="6"
                                                    Flex="33" />
                                                <ext:Column runat="server"
                                                    DataIndex="SCORE_5" Text="5"
                                                    Flex="33" />
                                                <ext:Column runat="server"
                                                    DataIndex="SCORE_4" Text="4"
                                                    Flex="33" />
                                                <ext:Column runat="server"
                                                    DataIndex="SCORE_3" Text="3"
                                                    Flex="33" />
                                                <ext:Column runat="server"
                                                    DataIndex="SCORE_2" Text="2"
                                                    Flex="33" />
                                                <ext:Column runat="server"
                                                    DataIndex="SCORE_1" Text="1"
                                                    Flex="33" />

                                            </Columns>
                                        </ColumnModel>
                                        <Store>
                                            <ext:Store
                                                ID="storScores"
                                                AutoLoad="true"
                                                runat="server">
                                                <Model>
                                                    <ext:Model runat="Server" IDProperty="MID">
                                                        <Fields>
                                                            <ext:ModelField Name="MID" />
                                                            <ext:ModelField Name="MODULE" />
                                                            <ext:ModelField Name="SHORT_NAME" />
                                                            <ext:ModelField Name="SCORE_10"/>
                                                            <ext:ModelField Name="SCORE_9" />
                                                            <ext:ModelField Name="SCORE_8" />
                                                            <ext:ModelField Name="SCORE_7" />
                                                            <ext:ModelField Name="SCORE_6" />
                                                            <ext:ModelField Name="SCORE_5" />
                                                            <ext:ModelField Name="SCORE_4" />
                                                            <ext:ModelField Name="SCORE_3" />
                                                            <ext:ModelField Name="SCORE_2" />
                                                            <ext:ModelField Name="SCORE_1" />
                                                            <ext:ModelField Name="DATE_10" />
                                                            <ext:ModelField Name="DATE_9" />
                                                            <ext:ModelField Name="DATE_8" />
                                                            <ext:ModelField Name="DATE_7" />
                                                            <ext:ModelField Name="DATE_6" />
                                                            <ext:ModelField Name="DATE_5" />
                                                            <ext:ModelField Name="DATE_4" />
                                                            <ext:ModelField Name="DATE_3" />
                                                            <ext:ModelField Name="DATE_2" />
                                                            <ext:ModelField Name="DATE_1" />
                                                            <ext:ModelField Name="NAME_10" />
                                                            <ext:ModelField Name="NAME_9" />
                                                            <ext:ModelField Name="NAME_8" />
                                                            <ext:ModelField Name="NAME_7" />
                                                            <ext:ModelField Name="NAME_6" />
                                                            <ext:ModelField Name="NAME_5" />
                                                            <ext:ModelField Name="NAME_4" />
                                                            <ext:ModelField Name="NAME_3" />
                                                            <ext:ModelField Name="NAME_2" />
                                                            <ext:ModelField Name="NAME_1" />
                                                            <ext:ModelField Name="INTERPRETATION_10" />
                                                            <ext:ModelField Name="INTERPRETATION_9" />
                                                            <ext:ModelField Name="INTERPRETATION_8" />
                                                            <ext:ModelField Name="INTERPRETATION_7" />
                                                            <ext:ModelField Name="INTERPRETATION_6" />
                                                            <ext:ModelField Name="INTERPRETATION_5" />
                                                            <ext:ModelField Name="INTERPRETATION_4" />
                                                            <ext:ModelField Name="INTERPRETATION_3" />
                                                            <ext:ModelField Name="INTERPRETATION_2" />
                                                            <ext:ModelField Name="INTERPRETATION_1" />
                                                        </Fields>
                                                    </ext:Model>
                                                </Model>
                                                <Reader>
                                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                                    </ext:JsonReader>
                                                </Reader>
                                            </ext:Store>
                                        </Store>
                                    </ext:GridPanel>

                                </Items>
                            </ext:Panel>

                            <%--Move to Code Behind C#
                                <ext:ToolTip ID="ttScores"
                                runat="server"
                                Target="={#{gpScores}.getView().el}"
                                Delegate=".x-grid-cell">
                                <Listeners>
                                    <BeforeShow Handler="return onBeforeShow(this, #{gpScores});" />
                                    <Show Handler="onShow(this, #{gpScores});" />
                                </Listeners>
                            </ext:ToolTip> --%>
                            
                            
                            <ext:Panel 
                                Title="Patient Notes by Date" 
                                Header="true" 
                                Split="true" 
                                Collapsible="false" 
                                Layout="AnchorLayout"
                                runat="server" 
                                Region="South" 
                                Border="false" 
                                Frame="false" 
                                Flex="1" 
                                MaintainFlex="true"
                                Anchor="100%"
                                AutoScroll="true">
                                <Items>

                                    <ext:GridPanel
                                        ID="gpNotes"
                                        runat="server"
                                        Title=""
                                        Layout="AnchorLayout"
                                        ColumnLines="true"
                                        RowLines="true"
                                        Anchor="100%"
                                        Border="false"
                                        HideHeaders="true">
                                        <Listeners>
                                            <Select Handler="UpdateNoteSel(#{gpNotes}.getSelectionModel().getCurrentPosition().row, #{gpNotes}.getSelectionModel().getCurrentPosition().column);"></Select>

                                            <CellClick Handler="App.direct.REPSPAT.OnNoteSelect(rowIndex, cellIndex, Ext.encode(this.store.getAt(rowIndex).data), { success: fnShowNote } );" />
                                        </Listeners>
                                        <SelectionModel>
                                            <ext:CellSelectionModel ID="csm" runat="server" Mode="Single">
                                                <Listeners>
                                                </Listeners>
                                                <CustomConfig>
                                                </CustomConfig>
                                            </ext:CellSelectionModel>
                                        </SelectionModel>
                                        <ColumnModel runat="server">
                                            <Columns>
                                                <ext:Column runat="server"
                                                    DataIndex="NOTE_1" Text=""
                                                    Flex="43" TdCls="gpUline">
                                                </ext:Column>
                                                <ext:Column runat="server"
                                                    DataIndex="NOTE_2" Text=""
                                                    Flex="43" TdCls="gpUline">
                                                </ext:Column>
                                                <ext:Column runat="server"
                                                    DataIndex="NOTE_3" Text=""
                                                    Flex="43" TdCls="gpUline">
                                                </ext:Column>
                                                <ext:Column runat="server"
                                                    DataIndex="NOTE_4" Text=""
                                                    Flex="43" TdCls="gpUline">
                                                </ext:Column>
                                                <ext:Column runat="server"
                                                    DataIndex="NOTE_5" Text=""
                                                    Flex="43" TdCls="gpUline">
                                                </ext:Column>
                                                <ext:Column runat="server"
                                                    DataIndex="NOTE_6" Text=""
                                                    Flex="43" TdCls="gpUline" EmptyCellText="">
                                                </ext:Column>

                                            </Columns>
                                        </ColumnModel>
                                        <Store>
                                            <ext:Store
                                                ID="storNotes"
                                                AutoLoad="true"
                                                runat="server">
                                                <Model>
                                                    <ext:Model runat="Server" IDProperty="">
                                                        <Fields>
                                                            <ext:ModelField Name="PATIENT_ID" />
                                                            <ext:ModelField Name="NOTE_1" />
                                                            <ext:ModelField Name="NOTE_2" />
                                                            <ext:ModelField Name="NOTE_3" />
                                                            <ext:ModelField Name="NOTE_4" />
                                                            <ext:ModelField Name="NOTE_5" />
                                                            <ext:ModelField Name="NOTE_6" />
                                                            <ext:ModelField Name="PATPWEVENT_1" />
                                                            <ext:ModelField Name="PATPWEVENT_2" />
                                                            <ext:ModelField Name="PATPWEVENT_3" />
                                                            <ext:ModelField Name="PATPWEVENT_4" />
                                                            <ext:ModelField Name="PATPWEVENT_5" />
                                                            <ext:ModelField Name="PATPWEVENT_6" />
                                                        </Fields>
                                                    </ext:Model>
                                                </Model>
                                                <Reader>
                                                    <ext:JsonReader RootProperty="Tables[0].Rows">
                                                    </ext:JsonReader>
                                                </Reader>
                                            </ext:Store>
                                        </Store>
                                         
                                    </ext:GridPanel>

                                </Items>
                                <BottomBar>
                                            <ext:Toolbar runat="server">
                                                <Items>
                                                    <ext:Button ID="btnShowNote" runat="server" Text="Select Note" Icon="Magnifier" 
                                                        Handler="App.direct.REPSPAT.OnNoteSelect(vNoteSelRow, vNoteSelCol,  Ext.encode(#{gpNotes}.getRowsValues({selectedOnly : true})), { success: fnShowNote }  )" >
                                                    <Listeners>
                                                       <AfterRender Handler="AriaShowNoteBtn(App.btnShowNote.getEl());" ></AfterRender>
                                                    </Listeners>
                                                    </ext:Button>

                                                </Items>
                                            </ext:Toolbar>
                                        </BottomBar>
                            </ext:Panel>
                        </Items>
                    </ext:Panel>
                </Items>
            </ext:Panel>

        </Items>
    </ext:Panel>



</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="cpScripts" runat="Server">
</asp:Content>

